/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.domain.use_case.read;

import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.AndroidFilter;
import com.android.core.utils.params.QueryParamTypes;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class MakeOrderQuery {
    private final DbConnection dbConnection;

    public Paging.PageSqlData invoke(RequestData request, LoginDto login) {
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        if (settingLoader.isUserForbiddenToFetchInvoices()) {
            return null;
        }
        String whereStr = "WHERE 1 = 1 " + this.getWhereStr(request);
        String sql = "SELECT rq.RqIndex AS id, rq.R_CusCode AS partyCode, rq.RqIndex2 AS code, \n rq.R_Date AS orderDate, u.[Name] as [owner], \n CASE IsNull(rq.RqType, 'F') WHEN 'K' THEN 0 WHEN 'F' THEN 1 END AS stockInfluence, \n IsNull(rqd.SumPrice, 0) AS finalPrice, rq.RqIndex AS serverId, \n rq.Comment AS description, IsNull(rq.Beianeh, 0) AS depositPrice, \n CONVERT(nvarchar(10), rq.T_Date, 120) AS deliverydate, \n CONVERT(nvarchar(8), rq.T_TIME, 108) AS deliveryTime, \n discountPrice = CASE WHEN serverDiscountPrice IS NULL THEN 0 \n   ELSE IsNull(rq.fTakhfif, 0) - IsNull(rq.serverDiscountPrice, 0) END, \n IsNull(rq.serverDiscountPrice, 0) AS serverDiscountPrice, \n IsNull(rq.serverCommissionPrice, 0) AS serverCommissionPrice, \n IsNull(ShowOrHide, 1) notConverted \n FROM RqTitle rq \n INNER JOIN (SELECT SUM(R_fewAval * R_Cost) sumPrice, rqIndex, RqType \n   FROM RqDetail";
        String articleIds = request.getParamValue("product-codes");
        if (articleIds != null && !articleIds.isEmpty()) {
            sql = sql + " where R_ArCode in ( " + articleIds + " ) ";
        }
        sql = sql + " GROUP BY rqIndex, RqType) rqd \n       ON rq.rqIndex = rqd.rqIndex AND rq.RqType = rqd.RqType \n INNER JOIN UserDB u ON rq.UserName = u.UserCodeInc \n";
        if (settingLoader.onlyAllowUserOrdersGetOrEdit()) {
            whereStr = whereStr + " AND rq.UserName = " + login.getUserCodeInc();
        }
        if (settingLoader.onlySendMidManCustomers()) {
            whereStr = whereStr + " AND rq.R_CusCode IN (SELECT C_Code FROM CustomerVaseteh WHERE Vaseteh_Code = " + ConvertStr.toQuotedSqlStr((String)settingLoader.getMidManId()) + ")";
        }
        sql = sql + whereStr;
        return Paging.PageSqlData.builder().selectSqlStr(sql).alias("rq").keyField("id").build();
    }

    @NotNull
    private String getWhereStr(RequestData request) {
        AndroidFilter filter = new AndroidFilter(request, QueryParamTypes.ORDER);
        String whereStr = filter.getFilter();
        if (!whereStr.isEmpty() && !whereStr.startsWith(" AND ")) {
            whereStr = " AND " + whereStr;
        }
        return whereStr;
    }

    public MakeOrderQuery(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

